const express = require("express");
const router = express.Router();
const userController = require("../../controllers/user/userController");
const auth = require("../../middelwares/auth");

router.post("/register", userController.register);
router.post("/active", userController.active);
router.post("/profile", auth, userController.updateProfile);
router.post("/addfriend", auth, userController.addFriend);
router.post("/friend", auth, userController.getFriends);

module.exports = router;
