const express = require("express");
const router = express.Router();
const teamController = require("../controllers/teamController");
const auth = require("../middelwares/auth");
const upload = require("../middelwares/upload");

router.post("/", upload.single("photo"), auth, teamController.create);
router.get("/", teamController.getAll);
router.post("/read", teamController.read);
router.post("/update", upload.single("photo"), auth, teamController.update);
router.post("/delete", auth, teamController._delete);

module.exports = router;
