const express = require("express");
const router = express.Router();
const formationController = require("../controllers/formationController");
const auth = require("../middelwares/auth");
const upload = require("../middelwares/upload");

router.post("/", auth, upload.single("photo"), formationController.create);
router.get("/", auth, formationController.getAll);
router.post("/read", auth, formationController.read);
router.post(
  "/update",
  auth,
  upload.single("photo"),
  formationController.update
);
router.post("/delete", auth, formationController._delete);

module.exports = router;
