const express = require("express");
const router = express.Router();
const dailyRewardController = require("../controllers/dailyRewardController");
const auth = require("../middelwares/auth");
const upload = require("../middelwares/upload");

router.post("/", auth, upload.single("photo"), dailyRewardController.create);
router.get("/", dailyRewardController.getAll);
router.post("/read", auth, dailyRewardController.read);
router.post(
  "/update",
  auth,
  upload.single("photo"),
  dailyRewardController.update
);
router.post("/delete", auth, dailyRewardController._delete);

module.exports = router;
