//prisma migrate dev or prisma db push

const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    day: Joi.string().required(),
    userId: Joi.number().required(),
  };
  console.log(0);

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    console.log(1);
    const day = req.body.day;
    const userId = req.body.userId;

    //

    //
    const data = {
      day,
      userId,
    };
    console.log(2, data);
    const getUserReward = await prisma.userReward.findFirst({
      where: { day: day },
    });

    console.log(3);
    if (getUserReward) res.status(404).send(".... قبلا ثبت شده است");
    else {
      const newUserReward = await prisma.userReward.create({
        data: data,
      });
      console.log(4);
      res.status(201).json(newUserReward);
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deleted = await prisma.userReward.delete({
      where: {
        id: req.body.id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deleted);
    res.status(200).json({ deleted });
  }
};

const getAll = async (req, res) => {
  const userRewards = await prisma.userReward
    .findMany
    // {
    // include: {
    //   posts: true,
    //   profile: true,
    // },  }
    ();
  res.status(200).json({ userRewards: userRewards });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const userRewardById = await prisma.userReward.findUnique({
      where: { id: req.body.id },
    });

    res.status(200).json({ userRewardById });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  // const schema = {
  //   day: Joi.string().required(),
  // };
  // const validateResult = Joi.object(schema).validate(req.body);
  try {
    // if (validateResult.error) {
    //   res.status(404).send(validateResult.error.message);
    //   return;
    // }

    // const day = req.body.day;
    // const updatedData = {
    //   day,
    // };
    // console.log(0, updatedData);

    const userId = req.userData.id;

    const thisUserReward = await prisma.userReward.findFirst({
      where: { userId: userId }, // Check if a profile exists with the user ID
    });
    console.log(0, userId, thisUserReward);

    if (thisUserReward) {
      console.log(1);

      const lastRewardDate = new Date(thisUserReward.lastReward);
      const today = new Date();
      const yesterday = new Date();
      yesterday.setDate(yesterday.getDate() - 1);

      const isToday = lastRewardDate.toDateString() === today.toDateString();
      const isTomorrow =
        lastRewardDate.toDateString() === yesterday.toDateString();

      if (isTomorrow) {
        console.log("tomarow");
        const thisDay = (thisUserReward.day + 1) % 7;
        const thisReward = await prisma.dailyReward.findFirst({
          where: { day: thisDay },
        });
        const updatedUserReward = await prisma.userReward.update({
          where: { userId: userId }, // Update the existing profile with the user ID
          data: { day: thisDay }, // Update specific fields
        });
        //update users balance
        const thisUserProfile = await prisma.profile.findUnique({
          where: { userId: userId },
        });
        let value = thisUserProfile.balance;
        value += 25;
        await prisma.profile.update({
          where: { id: thisUserProfile.id },
          data: { balance: value },
        });
        thisUserProfile.balance = value;
        res.status(200).json({ updatedUserReward, profile: thisUserProfile });
      } else if (!isToday) {
        console.log("a day after tomarrow");
        const thisReward = await prisma.dailyReward.findFirst({
          where: { day: 0 },
        });
        const thisUserProfile = await prisma.profile.findUnique({
          where: { userId: userId },
        });
        let value = thisUserProfile.balance;
        value += thisReward.reward;
        await prisma.profile.update({
          where: { id: thisUserProfile.id },
          data: { balance: value },
        });
        thisUserProfile.balance = value;

        const updatedUserReward = await prisma.userReward.update({
          where: { userId: userId }, // Update the existing profile with the user ID
          data: { day: 0 }, // Update specific fields
        });
        //update users Balance

        res.status(200).json({ updatedUserReward, profile: thisUserProfile });
      } else {
        res.status(400).json({ error: true, message: "get reward before" });
      }
    } else {
      const newUserReward = await prisma.userReward.create({
        data: {
          userId,
          day: 0,
        },
      });
      console.log(newUserReward);
      // update user balance
      const thisReward = await prisma.dailyReward.findFirst({
        where: { day: 0 },
      });
      const thisUserProfile = await prisma.profile.findUnique({
        where: { userId: userId },
      });
      let value = thisUserProfile.balance;
      value += thisReward.reward;
      await prisma.profile.update({
        where: { id: thisUserProfile.id },
        data: { balance: value },
      });
      thisUserProfile.balance = value;

      res.status(201).json({ newUserReward, profile: thisUserProfile });
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

const checkAvailblity = async (req, res) => {
  try {
    const userId = req.userData.id;

    const thisUserReward = await prisma.userReward.findFirst({
      where: { userId: userId },
    });
    console.log(0, userId, thisUserReward);
    const dailyRewards = await prisma.dailyReward.findMany();
    if (thisUserReward) {
      console.log(1);

      const lastRewardDate = new Date(thisUserReward.lastReward);
      const today = new Date();
      const yesterday = new Date();
      yesterday.setDate(yesterday.getDate() - 1);

      const isToday = lastRewardDate.toDateString() === today.toDateString();
      const isTomorrow =
        lastRewardDate.toDateString() === yesterday.toDateString();

      if (isToday) {
        res.status(200).json({
          available: false,
          last: thisUserReward.day,
          dailyRewards: dailyRewards,
          userReward: thisUserReward,
        });
      } else {
        res.status(200).json({
          available: true,
          last: isTomorrow ? thisUserReward.day : 0,
          dailyRewards: dailyRewards,
          userReward: thisUserReward,
        });
      }
    } else {
      res.status(200).json({
        available: true,
        last: 0,
        dailyRewards: dailyRewards,
        userReward: {
          day: 0,
          game: 0,
          gameCup: 0,
          win: 0,
          winCup: 0,
          loose: 0,
          looseCup: 0,
        },
      });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const userGameReward = async (userId, isWin) => {
  const userReward = await prisma.userReward.findUnique({
    where: { userId: userId },
  });
  userReward.game += 1;
  if (userReward.game % 10 == 0) {
    userReward.game = 0;
    userReward.gameCup += 1;
  }
  if (isWin) {
    userReward.win += 1;
    if (userReward.win % 10 == 0) {
      userReward.win = 0;
      userReward.winCup += 1;
    }
  } else {
    userReward.loose += 1;
    if (userReward.loose % 10 == 0) {
      userReward.loose = 0;
      userReward.looseCup += 1;
    }
  }

  await prisma.userReward.update({
    where: { id: userReward.id },
    data: userReward,
  });

  return userReward;
};

const checkTeamPlayerReward = (id) => {};

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,
  checkAvailblity,
  userGameReward,
};
