//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    title: Joi.string().required(),
    position: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const title = req.body.title;
    const position = req.body.position;

    const data = {
      title,
      position,
    };
    const getuserForamtionBytitle = await prisma.userForamtion.findFirst({
      where: { title: title },
    });
    if (getuserForamtionBytitle) res.status(404).send("ترکیب قبلا ثبت شده است");
    else {
      const newuserForamtion = await prisma.userForamtion.create({
        data: data,
      });
      res.status(201).json(newuserForamtion);
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deleted = await prisma.userForamtion.delete({
      where: {
        id: id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deleted);
    res.status(200).json({ deleted });
  }
};

const getAll = async (req, res) => {
  console.log(" : geting userForamtion");
  const userForamtions = await prisma.userForamtion
    .findMany
    // {
    // include: {
    //   posts: true,
    //   profile: true,
    // },  }
    ();
  res.status(200).json({ userForamtions: userForamtions });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const userForamtion = await prisma.userForamtion.findUnique({
      where: { id: req.body.id },
      include: { players: true }, // Include players relation
    });

    res.status(200).json({ userForamtion });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
    title: Joi.string().required(),
    position: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const id = req.body.id;
    const title = req.body.title;
    const position = req.bodt.position;
    const logo = `/uploads/${req.file.filetitle}`;

    const updateduserForamtionData = {
      title,
      position,
      logo,
    };

    const existingPlayer = await prisma.player.findUnique({
      where: { id: id }, // Check if a profile exists with the user ID
    });

    if (existingProfile) {
      console.log(1);
      const updateduserForamtion = await prisma.profile.update({
        where: { id: id }, // Update the existing profile with the user ID
        data: updateduserForamtionData, // Update specific fields
      });
      res.status(201).json(updateduserForamtion);
    } else {
      res.status(400).json({ error: "user not found" });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,
};
