//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

// const usersModel = require("../models/userModel");
// const regMessageModel = require("../models/regMessageModel");
// const visitDateModel = require("../models/visitDateModel");
// const axios = require("axios");
// const uiModel = require("../models/uiModel");
// const VisitModel = require("../models/visitDateModel");
// const WalletModel = require("../models/walletModel");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const register = async (req, res) => {
  const schema = {
    phone: Joi.string().length(10).required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const phone = req.body.phone;
    const existUser = await prisma.user.findUnique({
      where: { phone: phone },
    });
    console.log(11, existUser);
    if (existUser) {
      const code = "" + Math.floor(Math.random() * 90000 + 10000);
      console.log(12, code);
      const newUser = await prisma.user.update({
        where: { id: existUser.id },
        data: { code },
      });
      console.log(13, newUser);
      // send the code as sms
      res.status(200).json(newUser);
    } else {
      const code = "" + Math.floor(Math.random() * 90000 + 10000);
      console.log({ phone, code });
      const newUser = await prisma.user.create({
        data: { phone, code },
      });
      // send the code as sms
      const newCarts = await createRewartdCard(newUser.id);
      const newProfile = await prisma.profile.create({
        data: {
          userId: newUser.id,
          birthdate: new Date("1000-01-01 10:10:10"),
          logoUrl: JSON.stringify({
            icon: 0,
            shape: 0,
            color1: "#fff",
            color2: "#fff",
          }),
          team: "perspolis",
          balance: 250,
        },
      });
      res.status(201).json({ ...newUser, newCart: newCarts });
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

const createRewartdCard = async (userId) => {
  const newList = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15];
  const carts = [];
  for (const element of newList) {
    const newCardData = {
      userId: userId,
      serial: "JustReward",
      playerId: element,
      cost: 0,
    };
    const newCart = await prisma.cart.create({ data: newCardData });
    const player = await prisma.player.findUnique({ where: { id: element } });
    const newCart2 = { ...newCart, imgUrl: player.imgUrl };
    carts.push(newCart2);
  }
  return carts;
};

const active = async (req, res) => {
  const schema = {
    code: Joi.string().length(5).required(),
    phone: Joi.string().length(10).required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const phone = req.body.phone;
    const code = req.body.code;

    const getUserByPhone = await prisma.user.findUnique({
      where: { phone: phone },
      include: {
        profile: true,
        cart: true,
        userReward: true,
        userFormation: true,
      },
    });

    console.log("active 1");
    if (!getUserByPhone) res.status(404).send("کاربر قبلا ثبت نام نکرده است");
    else {
      if (getUserByPhone.code == code) {
        delete getUserByPhone.code;
        await prisma.user.update({
          where: { id: getUserByPhone.id },
          data: { code: "-xxx" },
        });
        res.status(200).json({
          token: jwt.sign({ id: getUserByPhone.id }, process.env.SECRET_KEY),
          user: getUserByPhone,
        });
      } else {
        res.status(400).json({ erro: true, message: "Wrong Code!" });
      }
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const updateProfile = async (req, res) => {
  const schema = {
    birthdate: Joi.string().required(),
    logoUrl: Joi.string().required(),
    team: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    console.log("sss");
    const userId = req.userData.id; /// need auth
    const birthdate = req.body.birthdate;
    const logoUrl = req.body.logoUrl;
    const team = req.body.team;
    const updatedProfileData = {
      birthdate: birthdate,
      logoUrl: logoUrl,
      team: team,
    };

    const existingProfile = await prisma.profile.findUnique({
      where: { userId }, // Check if a profile exists with the user ID
    });

    if (existingProfile) {
      console.log(1);
      const updatedProfile = await prisma.profile.update({
        where: { id: existingProfile.id }, // Update the existing profile with the user ID
        data: updatedProfileData, // Update specific fields
      });
      res.status(201).json(updatedProfile);
    } else {
      console.log({
        userId: userId,
        birthdate: birthdate,
        logoUrl: logoUrl,
        team: team,
      });
      const newProfile = await prisma.profile.create({
        data: {
          userId: userId,
          birthdate: new Date(birthdate),
          logoUrl: logoUrl,
          team: team,
        },
      });
      res.status(200).json(newProfile);
    }

    // const updatedProfile = await prisma.profile.upsert({
    //   where: { userId: userId }, // Update/Create based on user ID
    //   update: { data: updatedProfileData }, // Update data if profile exists
    //   create: {
    //     data: {
    //       userId: userId,
    //       birthDate: birthDate,
    //       logoUrl: logoUrl,
    //       team: team,
    //       balance: 0,
    //     },
    //   }, // Create new if not found
    // });
    // res.status(200).json(updatedProfile);
  } catch (error) {
    res.status(500).json({ error });
  }
};

const addFriend = async (req, res) => {
  const schema = {
    friendId: Joi.number().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    const userId = req.userData.id; /// need auth
    const friendId = req.body.friendId;

    const existingProfile = await prisma.profile.findUnique({
      where: { userId }, // Check if a profile exists with the user ID
    });

    if (existingProfile) {
      const friends = [...existingProfile.friends, friendId];
      const updatedProfileData = {
        friends: friends,
      };
      console.log(1);
      const updatedProfile = await prisma.profile.update({
        where: { id: existingProfile.id }, // Update the existing profile with the user ID
        data: updatedProfileData, // Update specific fields
      });
      res.status(201).json(updatedProfile);
    } else {
      res.status(400).json({ message: "Must update profile " });
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error: JSON.stringify(error) });
  }
};

const removeFriend = async (req, res) => {
  const schema = {
    friendId: Joi.number().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    const userId = req.userData.id; /// need auth
    const friendId = req.body.friendId;

    const existingProfile = await prisma.profile.findUnique({
      where: { userId }, // Check if a profile exists with the user ID
    });

    if (existingProfile) {
      const friends = existingProfile.friends.filter(item !== friendId);
      const updatedProfileData = {
        friends: friends,
      };
      console.log(1);
      const updatedProfile = await prisma.profile.update({
        where: { id: existingProfile.id }, // Update the existing profile with the user ID
        data: updatedProfileData, // Update specific fields
      });
      res.status(201).json(updatedProfile);
    } else {
      res.status(400).json({ message: "Must update profile " });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const getFriends = async (req, res) => {
  try {
    const userId = req.userData.id; /// need auth

    const existingProfile = await prisma.profile.findUnique({
      where: { userId }, // Check if a profile exists with the user ID
    });

    if (existingProfile) {
      const friends = existingProfile.friends;

      const friendList = await prisma.profile.findMany({
        where: { id: { in: friends } }, // Update the existing profile with the user ID
      });
      res.status(201).json(friendList);
    } else {
      res.status(400).json({ message: "Must update profile " });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

module.exports = {
  register,
  active,
  updateProfile,
  addFriend,
  removeFriend,
  getFriends,
};
