//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    name: Joi.string().required(),
    leage: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const name = req.body.name;
    const leage = req.body.leage ? req.body.leage : "universal";
    const logo = `/${req.file.filename}`; //`/uploads/${req.file.filename}`;

    const data = {
      name,
      leage,
      logo,
    };
    const getTeamByName = await prisma.team.findFirst({
      where: { name: name },
    });
    if (getTeamByName) res.status(404).send("تیم قبلا ثبت شده است");
    else {
      const newTeam = await prisma.team.create({
        data: data,
      });
      res.status(201).json(newTeam);
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deleted = await prisma.team.delete({
      where: {
        id: id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deleted);
    res.status(200).json({ deleted });
  }
};

const getAll = async (req, res) => {
  console.log(" : geting team");
  const teams = await prisma.team
    .findMany
    // {
    // include: {
    //   posts: true,
    //   profile: true,
    // },  }
    ();
  res.status(200).json({ teams: teams });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const team = await prisma.team.findUnique({
      where: { id: req.body.id },
      include: { players: true }, // Include players relation
    });

    res.status(200).json({ team });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
    name: Joi.string().required(),
    leage: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const id = parseInt(req.body.id);
    const name = req.body.name;
    const leage = req.body.leage;
    const logo = `/${req.file.filename}`; ///uploads

    console.log(id, name, leage, logo);
    const updatedTeamData = {
      name,
      leage,
      logo,
    };

    const existingTeam = await prisma.team.findUnique({
      where: { id: id }, // Check if a profile exists with the user ID
    });
    const teamViaName = await prisma.team.findFirst({
      where: { name: name }, // Check if a profile exists with the user ID
    });

    if (existingTeam) {
      console.log(1);
      if (!teamViaName || teamViaName.id == existingTeam.id) {
        const updatedTeam = await prisma.team.update({
          where: { id: id }, // Update the existing profile with the user ID
          data: updatedTeamData, // Update specific fields
        });
        res.status(201).json(updatedTeam);
      } else {
        res.status(400).json({ error: "name used before" });
      }
    } else {
      res.status(400).json({ error: "team not found" });
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error: JSON.stringify(error) });
  }
};

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,
};
