//prisma migrate dev or prisma db push
require("dotenv").config();
const crypto = require("crypto");

const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    name: Joi.string().required(),
    cost: Joi.number().required(),
    precent: Joi.string().required(),
    discount: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const name = req.body.name;
    const cost = req.body.cost;
    const precent = req.body.precent;
    const discount = req.body.discount;
    const data = {
      name,
      cost,
      precent,
      discount,
    };
    const getProductByName = await prisma.shopProduct.findFirst({
      where: { name: name },
    });
    if (getProductByName) res.status(404).send("بسته قبلا ثبت شده است");
    else {
      const newProduct = await prisma.shopProduct.create({
        data: data,
      });
      res.status(201).json(newProduct);
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deleted = await prisma.shopProduct.delete({
      where: {
        id: id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deleted);
    res.status(200).json({ deleted });
  }
};

const getAll = async (req, res) => {
  console.log(" : geting Product");
  const Products = await prisma.shopProduct
    .findMany
    // {
    // include: {
    //   posts: true,
    //   profile: true,
    // },  }
    ();
  res.status(200).json({ products: Products });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const Product = await prisma.shopProduct.findUnique({
      where: { id: req.body.id },
      include: { players: true }, // Include players relation
    });

    res.status(200).json({ Product });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
    name: Joi.string().required(),
    cost: Joi.number().required(),
    precent: Joi.string().required(),
    discount: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const id = req.body.id;
    const name = req.body.name;
    const cost = req.body.cost;
    const precent = req.body.precent;
    const discount = req.body.discount;
    const updatedProductData = {
      name,
      cost,
      precent,
      discount,
    };

    const existingProduct = await prisma.shopProduct.findUnique({
      where: { id: id }, // Check if a profile exists with the user ID
    });

    if (existingProduct) {
      console.log(1);
      const updatedProduct = await prisma.shopProduct.update({
        where: { id: id }, // Update the existing profile with the user ID
        data: updatedProductData, // Update specific fields
      });
      res.status(201).json(updatedProduct);
    } else {
      res.status(400).json({ error: "user not found" });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const buy = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const id = req.body.id;
    const data = {
      id,
    };
    const getProduct = await prisma.shopProduct.findUnique({
      where: { id: id },
    });

    if (!getProduct) res.status(404).send("بسته ای یافت نشد");
    else {
      //1 check user balance > cost
      //2 decrese balance -= cost
      //3 get 5 newPlayer via precent : {"common":55,"rare":30,"legendary":15}
      //state 1
      const userId = req.userData.id;
      const thisProfile = await prisma.profile.findFirst({
        where: { userId: userId },
      });
      console.log("thisProfile", thisProfile);

      if (!thisProfile || thisProfile.balance < getProduct.cost)
        res.status(400).send("موجودی کافی نیست");
      else {
        const ids = [];
        //state 2
        thisProfile.balance -= getProduct.cost;
        const updatedProfile = await prisma.profile.update({
          where: { id: thisProfile.id }, // Update the existing profile with the user ID
          data: { balance: thisProfile.balance }, // Update specific fields
        });
        //state 3
        const newCartList = [];

        const count = await prisma.player.count({
          where: { type: type },
        });

        for (let i = 0; i < 5; i++) {
          const rndNum = Math.random() * 100;
          console.log(
            getProduct.precent,
            getProduct.precent.common,
            getProduct.precent.rare
          );
          // const type =
          //   rndNum < getProduct.precent.common
          //     ? "COMMON"
          //     : rndNum - getProduct.precent.common < getProduct.precent.rare
          //     ? "RARE"
          //     : "LEGENDARY";
          let isIn = false;
          let teamIds = [];
          if (rndNum < getProduct.precent.common) {
            teamIds = [53, 54, 50];
          } else {
            if (rndNum - getProduct.precent.common < getProduct.precent.rare) {
              isIn = true;
              teamIds = [53];
            } else {
              isIn = true;
              teamIds = [50, 54];
            }
          }
          const type =
            rndNum < getProduct.precent.common
              ? "COMMON"
              : rndNum - getProduct.precent.common < getProduct.precent.rare
              ? "RARE"
              : "LEGENDARY";

          const randomIndex = Math.floor(Math.random() * count);

          const randomItem = await prisma.player.findMany({
            where: { type: type },
            take: 1,
            skip: randomIndex,
          });

          // items.push(randomItem[0]);
          let isExist = true;
          let newHash = "";
          while (isExist) {
            newHash = generateHash(
              randomIndex + new Date().toISOString + Math.random() * (10 ^ 7)
            );

            isExist = await prisma.cart.findFirst({
              where: { serial: newHash },
            });
          }
          // console.log({ playerId, serial: newHash, cost });
          console.log({
            playerId: randomItem[0].id,
            serial: newHash,
            cost: 400,
            userId: userId,
          });
          const newCart = await prisma.cart.create({
            data: {
              playerId: randomItem[0].id,
              serial: newHash,
              cost: 400,
              userId: userId,
            },
          });

          const thisPlayer = await prisma.player.findUnique({
            where: { id: randomItem[0].id },
          });
          ids.push(thisPlayer);
          newCartList.push(newCart);
        }

        res
          .status(201)
          .json({ profile: updatedProfile, carts: newCartList, players: ids });
      }
    }
  } catch (error) {
    console.log("buy product error:", error);
    res.status(500).json({ error: error });
  }
};

function generateHash(input) {
  return crypto.createHash("sha256").update(input).digest("hex").slice(0, 10); // Get the first 10 characters
}

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,
  buy,
};
