//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    name: Joi.string().required(),
    session: Joi.string().required(),
    serial: Joi.string().allow(),
    qrCode: Joi.string().allow(),
    teamId: Joi.number().required(),
    nationality: Joi.string().required(),
    isNationality: Joi.boolean().required(),
    color: Joi.string().allow(),
    defence: Joi.number().required(),
    attack: Joi.number().required(),
    type: Joi.string().required(),
    // imgUrl: Joi.string().required(),
    position: Joi.string().required(),
    control: Joi.string().required(),
    overal: Joi.string().required(),
  };
  console.log(0);

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }
    if (!req.file) {
      return res.status(400).send("Photo is required");
    }
    const imgUrl = `/${req.file.filename}`;

    console.log(1);
    const name = req.body.name;
    const session = req.body.session;
    const serial = req.body.serial;
    const qrCode = req.body.qrCode;
    const teamId = parseInt(req.body.teamId);
    const type = req.body.type;
    const nationality = req.body.nationality;
    const isNationality =
      req.body.isNationality == "true" || req.body.isNationality == "True";
    const color = req.body.color;
    const defence = parseInt(req.body.defence);
    const attack = parseInt(req.body.attack);
    const control = parseInt(req.body.control);
    const overal = parseInt(req.body.overal);
    // const imgUrl = req.body.imgUrl;
    const position = req.body.position;

    //

    //
    const data = {
      name,
      session,
      teamId,
      nationality,
      isNationality,
      color,
      defence,
      attack,
      imgUrl,
      position,
      control,
      overal,
    };
    if (serial) data.serial = serial;
    if (qrCode) data.qrCode = qrCode;
    console.log(2, data);
    const getPlayerByName = await prisma.player.findFirst({
      where: { name: name },
    });

    console.log(3);
    if (getPlayerByName) res.status(404).send("بازیکن قبلا ثبت شده است");
    else {
      const newPlayer = await prisma.player.create({
        data: data,
      });
      console.log(4);
      res.status(201).json(newPlayer);
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error: JSON.parse(error) });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deletedPlayer = await prisma.player.delete({
      where: {
        id: req.body.id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deletedPlayer);
    res.status(200).json({ deletedPlayer });
  }
};

const getAll = async (req, res) => {
  const allPlayers = await prisma.player
    .findMany
    // {
    // include: {
    //   posts: true,
    //   profile: true,
    // },  }
    ();
  res.status(200).json({ players: allPlayers });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const getPlayerById = await prisma.player.findUnique({
      where: { id: req.body.id },
    });

    res.status(200).json({ getPlayerById });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
    name: Joi.string().required(),
    session: Joi.string().required(),
    serial: Joi.string().allow(),
    qrCode: Joi.string().allow(),
    teamId: Joi.number().required(),
    nationality: Joi.string().required(),
    isNationality: Joi.boolean().required(),
    color: Joi.string().allow(),
    defence: Joi.number().required(),
    attack: Joi.number().required(),
    type: Joi.string().required(),
    // imgUrl: Joi.string().required(),
    position: Joi.string().required(),
    control: Joi.string().required(),
    overal: Joi.string().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const id = parseInt(req.body.id);
    const name = req.body.name;
    const session = req.body.session;
    const serial = req.body.serial;
    const qrCode = req.body.qrCode;
    const teamId = parseInt(req.body.teamId);
    const type = req.body.type;
    const nationality = req.body.nationality;
    const isNationality =
      req.body.isNationality == "true" || req.body.isNationality == "True";
    const color = req.body.color;
    const defence = parseInt(req.body.defence);
    const attack = parseInt(req.body.attack);
    const control = parseInt(req.body.control);
    const overal = parseInt(req.body.overal);
    const imgUrl = `/${req.file.filename}`;
    const position = req.body.position;

    const data = {
      name,
      session,
      teamId,
      nationality,
      isNationality,
      color,
      defence,
      attack,
      imgUrl,
      position,
      control,
      overal,
    };
    if (serial) data.serial = serial;
    if (qrCode) data.qrCode = qrCode;
    console.log(0, data);
    const existingPlayer = await prisma.player.findUnique({
      where: { id: id }, // Check if a profile exists with the user ID
    });

    console.log(0, existingPlayer);

    if (existingPlayer) {
      console.log(1);
      const updatedPlayer = await prisma.player.update({
        where: { id: id }, // Update the existing profile with the user ID
        data: data, // Update specific fields
      });
      res.status(201).json(updatedPlayer);
    } else {
      res.status(400).json({ error: "user not found" });
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

//
const createTest = async (req, res) => {
  console.log(0);

  const players = [
    {
      name: "Akram Afif",
      nationality: "Qatar",
      teamName: "Qatar",
      defence: 42,
      attack: 77,
      control: 84,
      overal: 80,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Aref Aghasi",
      nationality: "Iran",
      teamName: "Tractor",
      defence: 86,
      attack: 45,
      control: 72,
      overal: 84,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Farshad Ahmadzadeh",
      nationality: "Iran",
      teamName: "Fc persepolis",
      defence: 70,
      attack: 71,
      control: 73,
      overal: 83,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Salem Al Dawsari",
      nationality: "saudi arabia",
      teamName: "Saudi Arabia",
      defence: 75,
      attack: 77,
      control: 79,
      overal: 78,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Issa Alekasir",
      nationality: "Iran",
      teamName: "Fc persepolis",
      defence: 36,
      attack: 76,
      control: 71,
      overal: 75,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Ali Alipour",
      nationality: "Iran",
      teamName: "Fc persepolis",
      defence: 39,
      attack: 87,
      control: 72,
      overal: 84,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Alireza Alizadeh",
      nationality: "Iran",
      teamName: "Iran",
      defence: 80,
      attack: 82,
      control: 86,
      overal: 85,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Ricardo Alves",
      nationality: "Portugal",
      teamName: "Tractor",
      defence: 75,
      attack: 74,
      control: 71,
      overal: 76,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Lionel Alien Messi",
      nationality: "Argentina",
      teamName: "Matrix",
      defence: 69,
      attack: 97,
      control: 99,
      overal: 97,
      position: "Forward",
      type: "MATRIX",
    },
    {
      name: "Karim Ansarifard",
      nationality: "Iran",
      teamName: "Iran",
      defence: 68,
      attack: 88,
      control: 79,
      overal: 87,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Antony",
      nationality: "Brezil",
      teamName: "Manchester United",
      defence: 46,
      attack: 76,
      control: 87,
      overal: 81,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Pierre_Emerik Aubameyag",
      nationality: "France",
      teamName: "Droit Au But",
      defence: 35,
      attack: 83,
      control: 81,
      overal: 80,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Khodadad Azizi",
      nationality: "Iran",
      teamName: "Signature",
      defence: 67,
      attack: 93,
      control: 79,
      overal: 90,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Roberto Baggio",
      nationality: "Italy",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Karim Bagheri",
      nationality: "iran",
      teamName: "Signature",
      defence: 87,
      attack: 88,
      control: 89,
      overal: 94,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Franz Beckenbauer",
      nationality: "Germany",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Defender",
      type: "GOlDEN",
    },
    {
      name: "Alireza Beyranvand",
      nationality: "iran",
      teamName: "Tractor",
      defence: 84,
      attack: 35,
      control: 80,
      overal: 83,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Alireza Beyranvand",
      nationality: "Iran",
      teamName: "Fc persepolis",
      defence: 80,
      attack: 36,
      control: 82,
      overal: 81,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Ismael Bennacer",
      nationality: "France",
      teamName: "AC Milan",
      defence: 79,
      attack: 86,
      control: 81,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Karim Benzema",
      nationality: "France",
      teamName: "Ittihad Club",
      defence: 43,
      attack: 88,
      control: 87,
      overal: 88,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Lucas Beraldo",
      nationality: "Brezil",
      teamName: "Paris Germain",
      defence: 77,
      attack: 72,
      control: 73,
      overal: 75,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Victor Boniface",
      nationality: "Nigeria",
      teamName: "Leverkusen",
      defence: 37,
      attack: 74,
      control: 71,
      overal: 74,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Aitana Bonmati",
      nationality: "Spain",
      teamName: "FC Barcelona",
      defence: 75,
      attack: 91,
      control: 84,
      overal: 90,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Lucy Bronze",
      nationality: "England",
      teamName: "FC Barcelona",
      defence: 89,
      attack: 41,
      control: 74,
      overal: 87,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Gianluigi Buffon",
      nationality: "Italy",
      teamName: "Signature",
      defence: 96,
      attack: 89,
      control: 93,
      overal: 93,
      position: "Goalkeeper",
      type: "SIGNATURE",
    },
    {
      name: "Hakan Calhanoglu",
      nationality: "Turkey",
      teamName: "Inter Milan",
      defence: 70,
      attack: 80,
      control: 85,
      overal: 85,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Joao Cancelo",
      nationality: "Portugal",
      teamName: "FC Barcelona",
      defence: 80,
      attack: 73,
      control: 84,
      overal: 86,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Eric Cantona",
      nationality: "Argentina",
      teamName: "Signature",
      defence: 68,
      attack: 90,
      control: 92,
      overal: 90,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Olga Carmona",
      nationality: "Spain",
      teamName: "Real Madrid FC",
      defence: 86,
      attack: 43,
      control: 71,
      overal: 80,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Iker Casillas",
      nationality: "Spain",
      teamName: "Signature",
      defence: 89,
      attack: 52,
      control: 76,
      overal: 90,
      position: "Goalkeeper",
      type: "SIGNATURE",
    },
    {
      name: "Casimiro",
      nationality: "Brezil",
      teamName: "Manchester United",
      defence: 73,
      attack: 75,
      control: 89,
      overal: 89,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Rouzbeh Cheshmi",
      nationality: "Iran",
      teamName: "Esteghlal FC",
      defence: 73,
      attack: 68,
      control: 70,
      overal: 74,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Federico Chiesa",
      nationality: "Italy",
      teamName: "Juvetus ",
      defence: 53,
      attack: 82,
      control: 86,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Kingsley Coman",
      nationality: "France",
      teamName: "FC Bayern",
      defence: 30,
      attack: 79,
      control: 76,
      overal: 85,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Johan Cruyff",
      nationality: "Netherlands",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Ali Daei ",
      nationality: "Iran",
      teamName: "Signature",
      defence: 76,
      attack: 99,
      control: 95,
      overal: 99,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Darwin Nunez",
      nationality: "Uruguay",
      teamName: "Liverpool",
      defence: 43,
      attack: 81,
      control: 76,
      overal: 82,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Frenkie DE Jong",
      nationality: "Netherlands",
      teamName: "FC Barcelona",
      defence: 77,
      attack: 87,
      control: 86,
      overal: 87,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Alessandro Del Piero",
      nationality: "Italy",
      teamName: "Signature",
      defence: 72,
      attack: 94,
      control: 88,
      overal: 92,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Ousmane Dembele",
      nationality: "France",
      teamName: "Paris Germain",
      defence: 63,
      attack: 97,
      control: 87,
      overal: 86,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Rodrigo De Paul",
      nationality: "Argentina",
      teamName: "Atlético Madrid",
      defence: 75,
      attack: 85,
      control: 80,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Brahim Diaz",
      nationality: "Spain",
      teamName: "Real Madrid FC",
      defence: 24,
      attack: 98,
      control: 85,
      overal: 83,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Jeremy Doku",
      nationality: "Belgium",
      teamName: "Manchester City",
      defence: 25,
      attack: 67,
      control: 82,
      overal: 77,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Paulo Dybala",
      nationality: "Argentina",
      teamName: "AS Roma",
      defence: 40,
      attack: 85,
      control: 85,
      overal: 86,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Ayoub El Amloud",
      nationality: "Morocco",
      teamName: "Fc persepolis",
      defence: 80,
      attack: 47,
      control: 71,
      overal: 79,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Emre Can",
      nationality: "Germany",
      teamName: "Dortmund",
      defence: 82,
      attack: 87,
      control: 79,
      overal: 83,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Endrick Felipe ",
      nationality: "Brezil",
      teamName: "Real Madrid FC",
      defence: 45,
      attack: 93,
      control: 91,
      overal: 91,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Danial Esmaeilifar",
      nationality: "Iran",
      teamName: "Tractor",
      defence: 84,
      attack: 50,
      control: 72,
      overal: 82,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Joao Felix",
      nationality: "Portugal",
      teamName: "FC Barcelona",
      defence: 40,
      attack: 81,
      control: 85,
      overal: 81,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Pablo Gavi ",
      nationality: "Spain",
      teamName: "FC Barcelona",
      defence: 68,
      attack: 76,
      control: 85,
      overal: 83,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Zahra Ghanbari",
      nationality: "Iran",
      teamName: "Iran",
      defence: 50,
      attack: 88,
      control: 79,
      overal: 84,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Mehdi Ghayedi",
      nationality: "Iran",
      teamName: "Ittihad Kalba",
      defence: 32,
      attack: 87,
      control: 76,
      overal: 76,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Saman Ghoddos",
      nationality: "Iran",
      teamName: "Brentford",
      defence: 52,
      attack: 71,
      control: 68,
      overal: 68,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Ali Gholizadeh",
      nationality: "Iran",
      teamName: "Iran",
      defence: 80,
      attack: 88,
      control: 88,
      overal: 86,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Olivier Giroud",
      nationality: "France",
      teamName: "AC Milan",
      defence: 42,
      attack: 83,
      control: 74,
      overal: 82,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Anthony Gordon",
      nationality: "England",
      teamName: "Newcastle United",
      defence: 37,
      attack: 69,
      control: 75,
      overal: 75,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Antoine Griezmann",
      nationality: "France",
      teamName: "Atlético Madrid",
      defence: 58,
      attack: 88,
      control: 88,
      overal: 88,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Alejandro Grimaldo",
      nationality: "Spain",
      teamName: "Leverkusen",
      defence: 86,
      attack: 83,
      control: 84,
      overal: 84,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Alexis Guendouz",
      nationality: "Pakistan",
      teamName: "Fc persepolis",
      defence: 84,
      attack: 36,
      control: 81,
      overal: 82,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Serhou Guirassy",
      nationality: "Guinean",
      teamName: "Bundesliga",
      defence: 38,
      attack: 77,
      control: 76,
      overal: 76,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Haaland Terminator",
      nationality: "Norway",
      teamName: "Matrix",
      defence: 72,
      attack: 99,
      control: 92,
      overal: 98,
      position: "Forward",
      type: "MATRIX",
    },
    {
      name: "Ehsan Hajsafi",
      nationality: "Iran",
      teamName: "Iran",
      defence: 87,
      attack: 61,
      control: 78,
      overal: 86,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Sebastien Haller",
      nationality: "France",
      teamName: "Dortmund",
      defence: 52,
      attack: 81,
      control: 81,
      overal: 83,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Vahid Hashemian",
      nationality: "Iran",
      teamName: "Iran",
      defence: 53,
      attack: 90,
      control: 77,
      overal: 87,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Kai Havertz",
      nationality: "Germany",
      teamName: "Arsenal",
      defence: 45,
      attack: 79,
      control: 83,
      overal: 82,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Amin Hazbavi",
      nationality: "Iran",
      teamName: "Iran",
      defence: 84,
      attack: 62,
      control: 82,
      overal: 83,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Thierry Henrry",
      nationality: "France",
      teamName: "Signature",
      defence: 75,
      attack: 92,
      control: 89,
      overal: 92,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Ramus Hojlund",
      nationality: "Danmark",
      teamName: "Manchester United",
      defence: 45,
      attack: 80,
      control: 72,
      overal: 79,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Jalal Hosseini",
      nationality: "Iran",
      teamName: "Iran",
      defence: 90,
      attack: 52,
      control: 71,
      overal: 88,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Hossein Hosseini",
      nationality: "Iran",
      teamName: "Esteghlal FC",
      defence: 78,
      attack: 34,
      control: 80,
      overal: 79,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Mats Hummels",
      nationality: "Germany",
      teamName: "Dortmund",
      defence: 86,
      attack: 78,
      control: 70,
      overal: 83,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Mauro Icardi",
      nationality: "Argentina",
      teamName: " Galatasaray",
      defence: 40,
      attack: 81,
      control: 72,
      overal: 80,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Ciro Immobile",
      nationality: "Italy",
      teamName: "SS Lazio",
      defence: 39,
      attack: 87,
      control: 78,
      overal: 85,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Alexander Isak",
      nationality: "Sweden",
      teamName: "Newcastle United",
      defence: 39,
      attack: 81,
      control: 84,
      overal: 81,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Isco",
      nationality: "Spain",
      teamName: "Real Betis",
      defence: 59,
      attack: 88,
      control: 80,
      overal: 82,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Alireza Jahanbakhsh",
      nationality: "Iran",
      teamName: "Feyenoor FC",
      defence: 47,
      attack: 83,
      control: 74,
      overal: 73,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Oliver Kahn",
      nationality: "Germany",
      teamName: "Signature",
      defence: 94,
      attack: 51,
      control: 90,
      overal: 91,
      position: "Goalkeeper",
      type: "SIGNATURE",
    },
    {
      name: "Kaka",
      nationality: "Brezil",
      teamName: "Signature",
      defence: 64,
      attack: 86,
      control: 81,
      overal: 87,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Kaka",
      nationality: "Brezil",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Hossein Kanaanizadegan",
      nationality: "Iran",
      teamName: "Fc persepolis",
      defence: 78,
      attack: 51,
      control: 71,
      overal: 74,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Ali Karimi",
      nationality: "Iran",
      teamName: "Signature",
      defence: 66,
      attack: 83,
      control: 95,
      overal: 88,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Kevin Keegan",
      nationality: "England",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Sam Kerr",
      nationality: "Australia",
      teamName: "Chelsea",
      defence: 42,
      attack: 90,
      control: 74,
      overal: 90,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Mohammad Khakpour",
      nationality: "Iran",
      teamName: "Signature",
      defence: 90,
      attack: 61,
      control: 94,
      overal: 93,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Joshua Kimmich",
      nationality: "Germany",
      teamName: "FC Bayern",
      defence: 38,
      attack: 81,
      control: 85,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Ronald Koeman",
      nationality: "Netherlands",
      teamName: "Signature",
      defence: 97,
      attack: 77,
      control: 95,
      overal: 94,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Koke",
      nationality: "Spain",
      teamName: "Atlético Madrid",
      defence: 80,
      attack: 86,
      control: 76,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Ibrahima Konate",
      nationality: "France",
      teamName: "Liverpool",
      defence: 82,
      attack: 82,
      control: 68,
      overal: 81,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Jules Kounde",
      nationality: "France",
      teamName: "FC Barcelona",
      defence: 86,
      attack: 84,
      control: 80,
      overal: 85,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Takefusa Kubo",
      nationality: "Japan",
      teamName: "Japan",
      defence: 76,
      attack: 72,
      control: 73,
      overal: 80,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Khvicha Kvaratskhelia",
      nationality: "Georgia",
      teamName: "SSC Napoli",
      defence: 41,
      attack: 80,
      control: 87,
      overal: 86,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Rafael Leao",
      nationality: "Portugal",
      teamName: "AC Milan",
      defence: 27,
      attack: 80,
      control: 87,
      overal: 86,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Robert Lewandowski",
      nationality: "Poland",
      teamName: "FC Barcelona",
      defence: 76,
      attack: 93,
      control: 79,
      overal: 90,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Luis Diaz",
      nationality: "Colombia",
      teamName: "Liverpool",
      defence: 34,
      attack: 81,
      control: 87,
      overal: 84,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Romelu Lukaku",
      nationality: "Belgium",
      teamName: "AS Roma",
      defence: 38,
      attack: 84,
      control: 77,
      overal: 84,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Alexis Mac Allister",
      nationality: "Argentina",
      teamName: "Liverpool",
      defence: 70,
      attack: 79,
      control: 82,
      overal: 82,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Mehdi Mahdavikia",
      nationality: "Iran",
      teamName: "Iran",
      defence: 60,
      attack: 92,
      control: 81,
      overal: 89,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Farhad Majidi",
      nationality: "Iran",
      teamName: "Signature",
      defence: 50,
      attack: 75,
      control: 74,
      overal: 75,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Malcom",
      nationality: "Brezil",
      teamName: "Alhilal",
      defence: 28,
      attack: 84,
      control: 79,
      overal: 81,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Maldini",
      nationality: "Italy",
      teamName: "Signature",
      defence: 82,
      attack: 99,
      control: 90,
      overal: 94,
      position: "Defender",
      type: "SIGNATURE",
    },
    {
      name: "Paolo Maldini",
      nationality: "Italy",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Defender",
      type: "GOlDEN",
    },
    {
      name: "Diego Maradona",
      nationality: "Argentina",
      teamName: "Signature",
      defence: 88,
      attack: 92,
      control: 93,
      overal: 96,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Gabriel Martinelli",
      nationality: "Brezil",
      teamName: "Arsenal",
      defence: 46,
      attack: 78,
      control: 86,
      overal: 84,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Emiliamo Martinez",
      nationality: "Argentina",
      teamName: "Aston Villa",
      defence: 78,
      attack: 43,
      control: 85,
      overal: 85,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Mbappe Ninja",
      nationality: "France",
      teamName: "Matrix",
      defence: 36,
      attack: 97,
      control: 92,
      overal: 91,
      position: "Forward",
      type: "MATRIX",
    },
    {
      name: "Ferland Mendy",
      nationality: "France",
      teamName: "Real Madrid FC",
      defence: 92,
      attack: 77,
      control: 75,
      overal: 80,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Lionel Messi",
      nationality: "Argentina",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Lionel Messi",
      nationality: "Argentina",
      teamName: "FC Barcelona",
      defence: 50,
      attack: 99,
      control: 90,
      overal: 99,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Majid Hosseini",
      nationality: "Iran",
      teamName: "Iran",
      defence: 80,
      attack: 61,
      control: 74,
      overal: 81,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Kim Min Jae",
      nationality: "South Korea",
      teamName: "FC Bayern",
      defence: 85,
      attack: 33,
      control: 64,
      overal: 84,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Luka Modric",
      nationality: "Croatia",
      teamName: "Real Madrid FC",
      defence: 72,
      attack: 76,
      control: 87,
      overal: 87,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Luka Modric",
      nationality: "Croatia",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Midfielder",
      type: "GOlDEN",
    },
    {
      name: "Shahriyar Moghanlou",
      nationality: "Iran",
      teamName: "Sepahan ",
      defence: 50,
      attack: 72,
      control: 63,
      overal: 70,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Milad Mohammadi",
      nationality: "Iran",
      teamName: "Iran",
      defence: 86,
      attack: 62,
      control: 73,
      overal: 84,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Mohammad Mohebi",
      nationality: "iran",
      teamName: "Iran",
      defence: 80,
      attack: 78,
      control: 81,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Alvaro Borja Morata",
      nationality: "Spain",
      teamName: "Atlético Madrid",
      defence: 31,
      attack: 82,
      control: 79,
      overal: 83,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Thomas Muller",
      nationality: "Germany",
      teamName: "FC Bayern",
      defence: 55,
      attack: 82,
      control: 79,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Jamal Musiala",
      nationality: "Germany",
      teamName: "FC Bayern",
      defence: 63,
      attack: 75,
      control: 91,
      overal: 86,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Nacho Frenandez",
      nationality: "Spain",
      teamName: "Real Madrid FC",
      defence: 82,
      attack: 37,
      control: 71,
      overal: 83,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Ronaldo Nazario",
      nationality: "Brezil",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Omid Noorafkan",
      nationality: "iran",
      teamName: "Malavan",
      defence: 76,
      attack: 71,
      control: 72,
      overal: 73,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Sepideh Nozhati",
      nationality: "Iran",
      teamName: "Iran",
      defence: 82,
      attack: 51,
      control: 70,
      overal: 84,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Jan Oblak",
      nationality: "Slovenia",
      teamName: "Atlético Madrid",
      defence: 86,
      attack: 49,
      control: 87,
      overal: 88,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Dani Olmo",
      nationality: "Spain",
      teamName: "Spain",
      defence: 61,
      attack: 94,
      control: 81,
      overal: 90,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Cole Palmer",
      nationality: "England",
      teamName: "Chelsea",
      defence: 46,
      attack: 66,
      control: 70,
      overal: 66,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Pedri",
      nationality: "Spain",
      teamName: "FC Barcelona",
      defence: 83,
      attack: 86,
      control: 79,
      overal: 86,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Pele",
      nationality: "Brezil",
      teamName: "Signature",
      defence: 62,
      attack: 97,
      control: 97,
      overal: 99,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Pepe",
      nationality: "Portugal",
      teamName: "FC Porto",
      defence: 81,
      attack: 61,
      control: 75,
      overal: 81,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Jordan Pickford",
      nationality: "England",
      teamName: "England",
      defence: 89,
      attack: 61,
      control: 80,
      overal: 87,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Farshad Pious",
      nationality: "Iran",
      teamName: "Iran",
      defence: 61,
      attack: 92,
      control: 70,
      overal: 89,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Morteza Pouraliganji",
      nationality: "Iran",
      teamName: "Iran",
      defence: 87,
      attack: 68,
      control: 80,
      overal: 86,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Christian Pulisic",
      nationality: "United States",
      teamName: "AC Milan",
      defence: 37,
      attack: 84,
      control: 83,
      overal: 79,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Alexia Putellas",
      nationality: "Spain",
      teamName: "FC Barcelona",
      defence: 72,
      attack: 92,
      control: 90,
      overal: 91,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Carles Puyol",
      nationality: "Spain",
      teamName: "Signature",
      defence: 92,
      attack: 87,
      control: 90,
      overal: 90,
      position: "Defender",
      type: "SIGNATURE",
    },
    {
      name: "Roberto Carlos ",
      nationality: "Brezil",
      teamName: "Signature",
      defence: 95,
      attack: 82,
      control: 89,
      overal: 95,
      position: "Defender",
      type: "SIGNATURE",
    },
    {
      name: "Mehdi Rahmati",
      nationality: "Iran",
      teamName: "Iran",
      defence: 93,
      attack: 52,
      control: 87,
      overal: 88,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Ramin Rezaeian",
      nationality: "Iran",
      teamName: "Sepahan ",
      defence: 78,
      attack: 73,
      control: 74,
      overal: 78,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Sergio Ramos",
      nationality: "Spain",
      teamName: "FC Sevilla",
      defence: 92,
      attack: 88,
      control: 70,
      overal: 83,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Raphinha",
      nationality: "Brezil",
      teamName: "FC Barcelona",
      defence: 53,
      attack: 91,
      control: 86,
      overal: 84,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Raul gonzalez",
      nationality: "Spain",
      teamName: "Signature",
      defence: 60,
      attack: 95,
      control: 71,
      overal: 92,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Marco Reus",
      nationality: "Germany",
      teamName: "Dortmund",
      defence: 53,
      attack: 87,
      control: 85,
      overal: 83,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Ramin Rezaeian",
      nationality: "Iran",
      teamName: "Esteghlal FC",
      defence: 87,
      attack: 70,
      control: 72,
      overal: 86,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Arash Rezavand",
      nationality: "Iran",
      teamName: "Esteghlal FC",
      defence: 61,
      attack: 72,
      control: 70,
      overal: 73,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Richrlison",
      nationality: "Brezil",
      teamName: "Spurs",
      defence: 50,
      attack: 82,
      control: 79,
      overal: 80,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Andrew Robertson",
      nationality: "Scotland",
      teamName: "Liverpool",
      defence: 81,
      attack: 61,
      control: 81,
      overal: 86,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Rodri Hernandez",
      nationality: "Spain",
      teamName: "Spain",
      defence: 87,
      attack: 86,
      control: 90,
      overal: 92,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "James Rodriguez",
      nationality: "Colombia",
      teamName: "Colombia",
      defence: 78,
      attack: 80,
      control: 82,
      overal: 88,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Ronaldinho",
      nationality: "Brezil",
      teamName: "Signature",
      defence: 86,
      attack: 92,
      control: 96,
      overal: 96,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Ronaldinho Gaucho",
      nationality: "Brezil",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Ronaldo ",
      nationality: "Brezil",
      teamName: "Signature",
      defence: 67,
      attack: 94,
      control: 93,
      overal: 96,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Cristiano Ronaldo",
      nationality: "Portugal",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Cristiano Ronaldo",
      nationality: "Portugal",
      teamName: "Manchester United",
      defence: 50,
      attack: 99,
      control: 90,
      overal: 99,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Wayne Rooney",
      nationality: "England",
      teamName: "Signature",
      defence: 59,
      attack: 97,
      control: 70,
      overal: 96,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Kingsley Coman",
      nationality: "France",
      teamName: "FC Barcelona",
      defence: 48,
      attack: 87,
      control: 79,
      overal: 85,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Fabian Ruiz",
      nationality: "Spain",
      teamName: "Spain",
      defence: 80,
      attack: 78,
      control: 89,
      overal: 87,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Karl_Heinz Rummenigge",
      nationality: "Germany",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Saeid Ezatolahi",
      nationality: "Iran",
      teamName: "Iran",
      defence: 61,
      attack: 62,
      control: 60,
      overal: 65,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Salah Pharaoh",
      nationality: "Egypt",
      teamName: "Matrix",
      defence: 45,
      attack: 94,
      control: 89,
      overal: 91,
      position: "Forward",
      type: "MATRIX",
    },
    {
      name: "William Saliba",
      nationality: "France",
      teamName: "Arsenal",
      defence: 84,
      attack: 82,
      control: 83,
      overal: 83,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Jadon Sancho",
      nationality: "United Kingdom",
      teamName: "Dortmund",
      defence: 33,
      attack: 80,
      control: 81,
      overal: 82,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Saul Niguez Esclapez",
      nationality: "Spain",
      teamName: "Atlético Madrid",
      defence: 77,
      attack: 76,
      control: 78,
      overal: 80,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Allahyar Sayyadmanesh",
      nationality: "Iran",
      teamName: "Iran",
      defence: 68,
      attack: 87,
      control: 80,
      overal: 86,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Luke Shaw",
      nationality: "United Kingdom",
      teamName: "Manchester United",
      defence: 81,
      attack: 76,
      control: 79,
      overal: 83,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Reza Shekari",
      nationality: "Iran",
      teamName: "Iran",
      defence: 80,
      attack: 79,
      control: 83,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Shoja Khalilzadeh",
      nationality: "Iran",
      teamName: "Tractor",
      defence: 79,
      attack: 48,
      control: 74,
      overal: 76,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Masoud Shojaei",
      nationality: "Iran",
      teamName: "Signature",
      defence: 88,
      attack: 84,
      control: 89,
      overal: 90,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Yann Sommer",
      nationality: "Switzeland",
      teamName: "Inter Milan",
      defence: 83,
      attack: 44,
      control: 90,
      overal: 84,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Heung Mis Son",
      nationality: "South Korea",
      teamName: "Spurs",
      defence: 42,
      attack: 88,
      control: 84,
      overal: 87,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Mona Sorayyabin",
      nationality: "Iran",
      teamName: "Iran",
      defence: 80,
      attack: 81,
      control: 79,
      overal: 80,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Soroush Rafiei",
      nationality: "Iran",
      teamName: "Fc persepolis",
      defence: 62,
      attack: 69,
      control: 71,
      overal: 72,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Luis Suarez",
      nationality: "Uruguay",
      teamName: "Inter Miami",
      defence: 83,
      attack: 78,
      control: 80,
      overal: 83,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Wojciech Szczesny",
      nationality: "Poland",
      teamName: "Juvetus ",
      defence: 83,
      attack: 46,
      control: 87,
      overal: 86,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Mehdi Taremi",
      nationality: "Iran",
      teamName: "Inter Milan",
      defence: 50,
      attack: 88,
      control: 71,
      overal: 87,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Mehdi Taremi",
      nationality: "Iran",
      teamName: "FC Porto",
      defence: 38,
      attack: 81,
      control: 81,
      overal: 82,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Aurelien Tchouameni",
      nationality: "France",
      teamName: "Real Madrid FC",
      defence: 81,
      attack: 69,
      control: 78,
      overal: 84,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Marc-Andre Ter Stegen",
      nationality: "Germany",
      teamName: "FC Barcelona",
      defence: 93,
      attack: 78,
      control: 83,
      overal: 89,
      position: "Goalkeeper",
      type: "COMON",
    },
    {
      name: "Andranik Teymourian",
      nationality: "Iran",
      teamName: "Iran",
      defence: 81,
      attack: 68,
      control: 80,
      overal: 86,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Marcus Thuram",
      nationality: "France",
      teamName: "Inter Milan",
      defence: 48,
      attack: 77,
      control: 78,
      overal: 79,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Takehiro Tomiyasu",
      nationality: "Japan",
      teamName: "Japan",
      defence: 79,
      attack: 42,
      control: 70,
      overal: 78,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Mehdi Torabi",
      nationality: "Iran",
      teamName: "Fc persepolis",
      defence: 29,
      attack: 77,
      control: 76,
      overal: 76,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Ferran Torres",
      nationality: "Spain",
      teamName: "Spain",
      defence: 61,
      attack: 84,
      control: 70,
      overal: 82,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Fernando Torres",
      nationality: "Spain",
      teamName: "Signature",
      defence: 69,
      attack: 91,
      control: 89,
      overal: 90,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Oston Urunov",
      nationality: "Uzbekistan",
      teamName: "Fc persepolis",
      defence: 40,
      attack: 80,
      control: 72,
      overal: 77,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Alireza Vahedi Nikbakht",
      nationality: "Iran",
      teamName: "Iran",
      defence: 81,
      attack: 79,
      control: 84,
      overal: 87,
      position: "Midfielder",
      type: "COMON",
    },
    {
      name: "Marco Van Basten",
      nationality: "Netherlands",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Forward",
      type: "GOlDEN",
    },
    {
      name: "Ruud Van Nistelrooy",
      nationality: "Netherlands",
      teamName: "Signature",
      defence: 60,
      attack: 95,
      control: 71,
      overal: 94,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Robin Van Persie",
      nationality: "Netherlands",
      teamName: "Signature",
      defence: 54,
      attack: 96,
      control: 70,
      overal: 93,
      position: "Forward",
      type: "SIGNATURE",
    },
    {
      name: "Raphael Varane",
      nationality: "France",
      teamName: "Manchester United",
      defence: 86,
      attack: 49,
      control: 67,
      overal: 85,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Haaland Viking",
      nationality: "Norway",
      teamName: "Matrix",
      defence: 73,
      attack: 94,
      control: 90,
      overal: 92,
      position: "Forward",
      type: "MATRIX",
    },
    {
      name: "Timo Werner",
      nationality: "Germany",
      teamName: "RB Leipzig",
      defence: 35,
      attack: 80,
      control: 82,
      overal: 82,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Benjamin White",
      nationality: "England",
      teamName: "Arsenal",
      defence: 82,
      attack: 30,
      control: 74,
      overal: 80,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Nico Williams",
      nationality: "Spain",
      teamName: "Spain",
      defence: 60,
      attack: 80,
      control: 71,
      overal: 86,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Granit Xhaka",
      nationality: "Switzeland",
      teamName: "Leverkusen",
      defence: 75,
      attack: 74,
      control: 73,
      overal: 80,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Lamine Yamal",
      nationality: "Spain",
      teamName: "Spain",
      defence: 54,
      attack: 86,
      control: 72,
      overal: 84,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Lamine Yamal",
      nationality: "Spain",
      teamName: "FC Barcelona",
      defence: 43,
      attack: 85,
      control: 75,
      overal: 81,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Lev Yashin",
      nationality: "Russia",
      teamName: "Signature",
      defence: 96,
      attack: 71,
      control: 89,
      overal: 94,
      position: "Goalkeeper",
      type: "SIGNATURE",
    },
    {
      name: "Leny Yoro",
      nationality: "France",
      teamName: "Manchester United",
      defence: 88,
      attack: 40,
      control: 79,
      overal: 86,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Shahab Zahedi",
      nationality: "Iran",
      teamName: "Iran",
      defence: 60,
      attack: 87,
      control: 77,
      overal: 83,
      position: "Forward",
      type: "COMON",
    },
    {
      name: "Milad Zakipour",
      nationality: "Iran",
      teamName: "Esteghlal FC",
      defence: 86,
      attack: 55,
      control: 70,
      overal: 84,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Zinedine Zidane",
      nationality: "France",
      teamName: "Signature",
      defence: 72,
      attack: 89,
      control: 93,
      overal: 95,
      position: "Midfielder",
      type: "SIGNATURE",
    },
    {
      name: "Zinedine Zidane",
      nationality: "France",
      teamName: "Gold",
      defence: 100,
      attack: 100,
      control: 100,
      overal: 100,
      position: "Midfielder",
      type: "GOlDEN",
    },
    {
      name: "Oleksandr Zinchenko",
      nationality: "Ukraine",
      teamName: "Arsenal",
      defence: 78,
      attack: 66,
      control: 83,
      overal: 80,
      position: "Defender",
      type: "COMON",
    },
    {
      name: "Zlatan Ibrahimovic",
      nationality: "Sweden",
      teamName: "Signature",
      defence: 72,
      attack: 92,
      control: 90,
      overal: 90,
      position: "Forward",
      type: "SIGNATURE",
    },
  ];

  const uniqueTeamNames = [
    ...new Set(players.map((player) => player.teamName)),
  ];

  const updatedPlayers = players.map(({ teamName, ...player }) => ({
    ...player,
    isNationality: player.nationality === teamName,
    session: "2023-24",
    serial: "serial",
    qrCode: "qrCode",
    teamId: "",
    color: "red",
    imgUrl: "/143.webp",
    teamId: uniqueTeamNames.indexOf(teamName) + 45,
  }));

  try {
    const teamsData = uniqueTeamNames.map((item) => ({
      name: item,
      leage: "America",
      logo: "/miami.jpg",
    }));

    // const newTeams = await prisma.team.createMany({
    //   data: teamsData,
    //   skipDuplicates: true,
    // });
    // console.log(newTeams);

    // const playersData = [
    //   {
    //     name: "Lionel Messi",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 26,
    //     nationality: "Argentina",
    //     isNationality: false,
    //     color: "red",
    //     defence: 33,
    //     attack: 87,
    //     overal: 90,
    //     control: 94,
    //     imgUrl: "/143.webp",
    //     position: "FORWARD",
    //   },
    //   {
    //     name: "Nathan Ake'",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 27,
    //     nationality: "France",
    //     isNationality: false,
    //     color: "blue",
    //     defence: 82,
    //     attack: 53,
    //     overal: 81,
    //     control: 74,
    //     imgUrl: "/157.webp",
    //     position: "DEFENDER",
    //   },
    //   {
    //     name: "Alison Becker",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 4,
    //     nationality: "Brasilia",
    //     isNationality: false,
    //     color: "green",
    //     defence: 87,
    //     attack: 46,
    //     overal: 89,
    //     control: 89,
    //     imgUrl: "/165.webp",
    //     position: "GOALKEEPER",
    //   },
    //   {
    //     name: "Trent Alexanser Arnold",
    //     session: "20223-4",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 4,
    //     nationality: "England",
    //     isNationality: false,
    //     color: "blue",
    //     defence: 80,
    //     attack: 69,
    //     overal: 86,
    //     control: 79,
    //     imgUrl: "/171.webp",
    //     position: "DEFENDER",
    //   },
    //   {
    //     name: "Marco Asensio",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 9,
    //     nationality: "Spain",
    //     isNationality: false,
    //     color: "red",
    //     defence: 43,
    //     attack: 81,
    //     overal: 83,
    //     control: 83,
    //     imgUrl: "/176.webp",
    //     position: "FORWARD",
    //   },
    //   {
    //     name: "Nicolo Barella",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 28,
    //     nationality: "Italy",
    //     isNationality: false,
    //     color: "yellow",
    //     defence: 78,
    //     attack: 78,
    //     overal: 86,
    //     control: 85,
    //     imgUrl: "/177.webp",
    //     position: "MIDFIELDER",
    //   },
    //   {
    //     name: "Luka Modrić",
    //     session: "2024",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 1,
    //     nationality: "Croatia",
    //     isNationality: false,
    //     color: "white",
    //     defence: 70,
    //     attack: 80,
    //     overal: 83,
    //     control: 100,
    //     imgUrl: "url",
    //     position: "MIDFIELDER",
    //   },
    //   {
    //     name: "Jude Bellingham",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 2,
    //     nationality: "England",
    //     isNationality: false,
    //     color: "Yellow",
    //     defence: 78,
    //     attack: 75,
    //     overal: 86,
    //     control: 85,
    //     imgUrl: "/181.webp",
    //     position: "MIDFIELDER",
    //   },
    //   {
    //     name: "Bernardo Silva",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 27,
    //     nationality: "Spain",
    //     isNationality: false,
    //     color: "yellow",
    //     defence: 70,
    //     attack: 78,
    //     overal: 88,
    //     control: 92,
    //     imgUrl: "/182.webp",
    //     position: "GOALKEEPER",
    //   },
    //   {
    //     name: "Kevin De Bruyne",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 27,
    //     nationality: "Bellingham",
    //     isNationality: false,
    //     color: "yellow",
    //     defence: 65,
    //     attack: 88,
    //     overal: 91,
    //     control: 87,
    //     imgUrl: "/195.webp",
    //     position: "MIDFIELDER",
    //   },
    //   {
    //     name: "Matthijs De Light",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 5,
    //     nationality: "France",
    //     isNationality: false,
    //     color: "blue",
    //     defence: 85,
    //     attack: 61,
    //     overal: 86,
    //     control: 68,
    //     imgUrl: "/200.webp",
    //     position: "DEFENDER",
    //   },
    //   {
    //     name: "Edvardo Camavinga",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 2,
    //     nationality: "France",
    //     isNationality: false,
    //     color: "yellow",
    //     defence: 76,
    //     attack: 68,
    //     overal: 82,
    //     control: 82,
    //     imgUrl: "/186.webp",
    //     position: "MIDFIELDER",
    //   },
    //   // Add similar data for other teams and players

    //   {
    //     name: "Daniel carvajal",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 2,
    //     nationality: "England",
    //     isNationality: false,
    //     color: "blue",
    //     defence: 78,
    //     attack: 56,
    //     overal: 82,
    //     control: 79,
    //     imgUrl: "187.webp",
    //     position: "DEFENDER",
    //   },
    //   {
    //     name: "Alphonso Davies",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 5,
    //     nationality: "Portugal",
    //     isNationality: false,
    //     color: "blue",
    //     defence: 74,
    //     attack: 66,
    //     overal: 83,
    //     control: 84,
    //     imgUrl: "/191.webp",
    //     position: "DEFENDER",
    //   },
    //   {
    //     name: "Rodrigo Javier De Paul",
    //     session: "2023-24",
    //     serial: "serial",
    //     qrCode: "qrCode",
    //     teamId: 5,
    //     nationality: "Argentina",
    //     isNationality: false,
    //     color: "yellow",
    //     defence: 75,
    //     attack: 77,
    //     overal: 8843,
    //     control: 82,
    //     imgUrl: "/204.webp",
    //     position: "MIDFIELDER",
    //   },
    //   //
    // ];

    const newPlayaers = await prisma.player.createMany({
      data: updatedPlayers,
      skipDuplicates: true,
    });
    console.log(newPlayaers);
    res.status(200).json({ newTeams });
  } catch (error) {
    console.log(error);
    res.status(500).json({ error });
  }
};

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,
  createTest,
};
