//prisma migrate dev or prisma db push
const Joi = require("joi");
require("dotenv").config();

const leageController = require("./leageController");

//prisma
const { PrismaClient } = require("@prisma/client");
const { userGameReward } = require("./user/userRewardController");
const prisma = new PrismaClient();
//

const viaBot = async (req, res) => {
  // must be 4-3-3 , but here is 4-0-6
  const schema = {
    formation: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    console.log(req.body);
    const ids = JSON.parse(req.body.formation);
    const players = await prisma.player.findMany({
      where: {
        id: {
          in: ids,
        },
      },
    });

    // Sort and get the top 6 by defence
    const topDefenceModels = players
      .sort((a, b) => b.defence - a.defence)
      .slice(0, 6);
    const averageDefence =
      topDefenceModels.reduce((sum, model) => sum + model.defence, 0) /
      topDefenceModels.length;
    console.log(`Average Defence: ${averageDefence}`);

    // Sort and get the top 6 by attack
    const topAttackModels = players
      .sort((a, b) => b.attack - a.attack)
      .slice(0, 6);
    const averageAttack =
      topAttackModels.reduce((sum, model) => sum + model.attack, 0) /
      topAttackModels.length;
    console.log(`Average Attack: ${averageAttack}`);

    // // Fetch all models with defence greater than the average defence from the database
    // let modelsWithHighDefence = await prisma.player.findMany({
    //   where: {
    //     defence: {
    //       gt: averageDefence,
    //     },
    //     position: {
    //       not: "GOALKEEPER",
    //     },
    //   },
    // });

    // // If there are not enough players, fill with the best available
    // if (modelsWithHighDefence.length < 4) {
    //   const additionalDefenceModels = players
    //     .sort((a, b) => b.defence - a.defence)
    //     .slice(0, 4 - modelsWithHighDefence.length);
    //   modelsWithHighDefence = modelsWithHighDefence.concat(
    //     additionalDefenceModels
    //   );
    // }

    // // Shuffle the array and select 4 random models
    // const randomDefenceModels = modelsWithHighDefence
    //   .sort(() => 0.5 - Math.random())
    //   .slice(0, 4);

    // // Fetch all models with attack greater than the average attack from the database
    // let forwardsWithHighAttack = await prisma.player.findMany({
    //   where: {
    //     attack: {
    //       gt: averageAttack,
    //     },
    //     position: "FORWARD",
    //   },
    // });

    // let midfieldersWithHighAttack = await prisma.player.findMany({
    //   where: {
    //     attack: {
    //       gt: averageAttack,
    //     },
    //     position: "MIDFIELDER",
    //   },
    // });

    // // If there are not enough forwards, fill with the best available
    // if (forwardsWithHighAttack.length < 3) {
    //   const additionalForwards = players
    //     .filter((player) => player.position === "FORWARD")
    //     .sort((a, b) => b.attack - a.attack)
    //     .slice(0, 3 - forwardsWithHighAttack.length);
    //   forwardsWithHighAttack =
    //     forwardsWithHighAttack.concat(additionalForwards);
    // }

    // If there are not enough midfielders, fill with the best available
    // if (midfieldersWithHighAttack.length < 3) {
    //   const additionalMidfielders = players
    //     .filter((player) => player.position === "MIDFIELDER")
    //     .sort((a, b) => b.attack - a.attack)
    //     .slice(0, 3 - midfieldersWithHighAttack.length);
    //   midfieldersWithHighAttack = midfieldersWithHighAttack.concat(
    //     additionalMidfielders
    //   );
    // }

    // // Shuffle the arrays and select 3 random models from each
    // const randomForwards = forwardsWithHighAttack
    //   .sort(() => 0.5 - Math.random())
    //   .slice(0, 3);

    // const randomMidfielders = midfieldersWithHighAttack
    //   .sort(() => 0.5 - Math.random())
    //   .slice(0, 3);

    //
    const allPlayers = await prisma.player.findMany({
      where: {
        position: {
          not: "GOALKEEPER",
        },
      },
    });

    // Get 3 players with the nearest attack to the defence average
    const nearestAttackForward = allPlayers
      .filter((item) => item.position == "FORWARD")
      .sort(
        (a, b) =>
          Math.abs(a.attack - averageDefence) -
          Math.abs(b.attack - averageDefence)
      )
      .slice(0, 3);

    // Get 3 players with the nearest attack to the defence average
    const nearestAttackMid = allPlayers
      .filter((item) => item.position == "MIDFIELDER")
      .sort(
        (a, b) =>
          Math.abs(a.attack - averageDefence) -
          Math.abs(b.attack - averageDefence)
      )
      .slice(0, 3);

    console.log(nearestAttackForward.length, nearestAttackMid.length);
    const nearestAttackPlayers = [...nearestAttackForward, ...nearestAttackMid];
    // Get 3 players with the nearest defence to the attack average, excluding the first list
    const nearestDefencePlayers = allPlayers
      .filter(
        (player) =>
          player.position == "DEFENDER" &&
          !nearestAttackPlayers.includes(player)
      )
      .sort(
        (a, b) =>
          Math.abs(a.defence - averageAttack) -
          Math.abs(b.defence - averageAttack)
      )
      .slice(0, 4);

    //

    // Goalkeeper
    const count = await prisma.player.count({
      where: {
        position: "GOALKEEPER",
      },
    });

    // Generate a random offset
    const randomOffset = Math.floor(Math.random() * count);

    // Fetch one model using the random offset
    const randomGoalKeeper = await prisma.player.findMany({
      where: {
        position: "GOALKEEPER",
      },
      take: 1,
      skip: randomOffset,
    });

    console.log([
      nearestAttackPlayers.length,
      nearestDefencePlayers.length,
      randomGoalKeeper.length,
    ]);
    res
      .status(200)
      .json([
        ...nearestAttackPlayers,
        ...nearestDefencePlayers,
        ...randomGoalKeeper,
      ]);
  } catch (error) {
    res.status(500).json({ error });
  }
};

async function getRandomModels() {
  const randomNumber = Math.floor(Math.random() * 101);
  console.log(`Random number: ${randomNumber}`);

  const allModels = await prisma.modelName.findMany({
    where: {
      value: {
        gt: randomNumber,
      },
    },
  });

  // Shuffle the array and select 6 random models
  const shuffledModels = allModels.sort(() => 0.5 - Math.random());
  const selectedModels = shuffledModels.slice(0, 6);

  return selectedModels;
}

const resultViaBot = async (req, res) => {
  const schema = {
    score: Joi.string().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const score = JSON.parse(req.body.score);
    const userId = req.userData.id;

    const thisUserProfile = await prisma.profile.findUnique({
      where: { userId: userId },
    });

    if (!thisUserProfile) res.status(404).send("کاربر قبلا ثبت نام نکرده است");
    else {
      if (score[0] > score[1]) {
        let value = thisUserProfile.balance;
        value += 25;
        let value2 = thisUserProfile.points;
        value2 += 3;
        await prisma.profile.update({
          where: { id: thisUserProfile.id },
          data: { balance: value, points: value2 },
        });
        thisUserProfile.balance = value;
        const userReward = await userGameReward(userId, 1);

        await leageController.updatePoint(userId, 3);
        res.status(200).json({
          profile: thisUserProfile,
          reward: userReward,
        });
      } else {
        const userReward = await userGameReward(userId, 0);
        res.status(200).json({
          profile: thisUserProfile,
          reward: userReward,
        });
      }
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

module.exports = {
  viaBot,
  resultViaBot,
};
