//prisma migrate dev or prisma db push
const Joi = require("joi");
const bcrypt = require("bcryptjs");
require("dotenv").config();
const jwt = require("jsonwebtoken");
const crypto = require("crypto");

//prisma
const { PrismaClient } = require("@prisma/client");
const prisma = new PrismaClient();
//

const create = async (req, res) => {
  const schema = {
    playerId: Joi.number().required(),
    cost: Joi.number().required(),
    count: Joi.number().required(),
    prefix: Joi.string().length(2).required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const playerId = req.body.playerId;
    const cost = req.body.cost;
    const count = req.body.count;
    const prefix = req.body.count;

    const isExistPlayer = await prisma.player.findFirst({
      where: { id: playerId },
    });

    const allPlayers = await prisma.player.findMany();
    console.log(1, isExistPlayer, allPlayers);

    if (!isExistPlayer) {
      res.status(404).send("بازیکن ثبت نشده است");
      return;
    } else {
      let newCartList = [];
      for (let i = 0; i < count; i++) {
        console.log(i);
        let isExist = true;
        let newHash = "";
        while (isExist) {
          newHash = generateHash(
            i + new Date().toISOString + Math.random() * (10 ^ 7) + prefix
          );
          newHash = newHash[0] + prefix + newHash.slice(1);

          isExist = await prisma.cart.findFirst({
            where: { serial: newHash },
          });

          console.log(i, newHash, isExist);
        }
        // console.log({ playerId, serial: newHash, cost });
        const newCart = await prisma.cart.create({
          data: { playerId, serial: newHash, cost },
        });
        newCartList.push(newCart);
      }
      res.status(201).json({ carts: newCartList });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const _delete = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const deletedCart = await prisma.cart.delete({
      where: {
        id: id, // Replace with the ID of the record you want to delete
      },
    });
    console.log(deletedCart);
    res.status(200).json({ deletedCart });
  }
};

const getAll = async (req, res) => {
  const allCart = await prisma.cart.findMany();
  res.status(200).json({ palayers: allCart });
};

const read = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const getCartById = await prisma.cart.findUnique({
      where: { id: req.body.id },
    });

    res.status(200).json({ getCartById });
  } catch (error) {
    res.status(500).json({ error: error });
  }
};

const update = async (req, res) => {
  const schema = {
    id: Joi.number().required(),
    playerId: Joi.number().required(),
    cost: Joi.number().required(),
  };

  const validateResult = Joi.object(schema).validate(req.body);
  try {
    if (validateResult.error) {
      res.status(404).send(validateResult.error.message);
      return;
    }

    const cartId = req.body.playerId;
    const cost = req.body.cost;
    const id = req.body.id;
    const updatedCartData = {
      playerId,
      cost,
    };

    const existingCart = await prisma.player.findUnique({
      where: { id: id }, // Check if a profile exists with the user ID
    });

    if (existingCart) {
      console.log(1);
      const updatedCart = await prisma.profile.update({
        where: { id: id }, // Update the existing profile with the user ID
        data: updatedCartData, // Update specific fields
      });
      res.status(201).json(updatedCart);
    } else {
      res.status(400).json({ error: "user not found" });
    }
  } catch (error) {
    res.status(500).json({ error });
  }
};

const getMineAll = async (req, res) => {
  try {
    const userId = req.userData.id;
    const myCarts = await prisma.cart.findMany({
      where: {
        userId: userId,
      },
    });
    res.status(200).json(myCarts);
  } catch (error) {
    res.status(500).json({ error });
  }
};

const register = async (req, res) => {
  const schema = {
    serial: Joi.string().length(10).required(),
  };
  const validateResult = Joi.object(schema).validate(req.body);
  if (validateResult.error) res.status(404).send(validateResult.error.message);
  else {
    const userId = req.userData.id;
    const serial = req.body.serial;
    console.log(serial);
    const existingCart = await prisma.cart.findFirst({
      where: { serial: serial }, // Check if a profile exists with the user ID
    });

    if (existingCart) {
      console.log(1);
      if (existingCart.userId) {
        res.status(400).send("cart used before");
        return;
      }
      const updatedCart = await prisma.cart.update({
        where: { id: existingCart.id }, // Update the existing profile with the user ID
        data: { userId }, // Update specific fields
      });
      const getedPlayer = await prisma.player.findUnique({
        where: { id: updatedCart.playerId },
        include: { cart },
      });

      res.status(200).json({ cart: updatedCart, player: getedPlayer });
    } else {
      res.status(400).send("cart not found");
    }
  }
};

const list = async (req, res) => {
  usersModel.getAllUser().then((result) => res.send(result));
};

const sell = async (req, res) => {
  usersModel.getUserById(req.userData.id).then((result) => res.send(result));
};

function generateHash(input) {
  return crypto.createHash("sha256").update(input).digest("hex").slice(0, 8); // Get the first 10 characters
}

module.exports = {
  create,
  getAll,
  read,
  update,
  _delete,

  getMineAll,
  register,
  list,
  sell,
};
